<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMemorialPersonsTable extends Migration {

	public function up()
	{
		Schema::create('memorial_persons', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('memory_id')->unsigned();
			$table->string('full_name', 255);
			$table->string('birth_date')->nullable();
			$table->enum('birth_calendar', array('gregorian', 'hijri'))->nullable();
			$table->string('death_date', 255)->nullable();
			$table->enum('death_calendar', array('gregorian', 'hijri'));
			$table->integer('living_city_id')->unsigned();
			$table->integer('death_city_id')->unsigned();
			$table->integer('job_id')->unsigned();
			$table->integer('institutions_id')->unsigned();
			$table->longText('description')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('memorial_persons');
	}
}