<?php

namespace Traveler;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Traveler extends Model 
{

    protected $table = 'trips';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('first_name', 'last_name', 'email', 'phone_number', 'pnr', 'from_airport_id', 'trip_date', 'test_result_url', 'vaccination_certificate_url', 'passport_front_page_url', 'test_result_password', 'vaccination_certificate_password', 'passport_front_page_password', 'questions', 'status', 'countries_traveled');

    public function lab()
    {
        return $this->hasOne('Lab');
    }

    public function fromAirport()
    {
        return $this->hasOne('Airport');
    }

    public function toAirport()
    {
        return $this->hasOne('Airport');
    }

}