<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('trips', function(Blueprint $table) {
			$table->foreign('from_airport_id')->references('id')->on('airports')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->foreign('to_airport_id')->references('id')->on('')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->foreign('lab_id')->references('id')->on('labs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('trips', function(Blueprint $table) {
			$table->dropForeign('trips_from_airport_id_foreign');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->dropForeign('trips_to_airport_id_foreign');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->dropForeign('trips_lab_id_foreign');
		});
	}
}