<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateParticipantsTable extends Migration {

	public function up()
	{
		Schema::create('participants', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('email');
			$table->string('name')->nullable();
			$table->string('postal_code')->nullable();
			$table->string('city')->nullable();
			$table->boolean('newsletter')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('participants');
	}
}