<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCampaignTable extends Migration {

	public function up()
	{
		Schema::create('campaign', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name')->unique();
			$table->text('description');
			$table->datetime('date_start');
			$table->datetime('date_end');
			$table->tinyInteger('participation_type');
			$table->boolean('active')->default(0);
			$table->boolean('only_facebook')->default(0);
			$table->boolean('no_prize')->default(0);
			$table->string('background');
			$table->string('url');
			$table->string('email_sender');
			$table->string('logo');
			$table->string('left_banner')->nullable();
			$table->string('right_banner')->nullable();
			$table->string('corporate_color');
			$table->string('background_roulette');
			$table->string('legal_text');
			$table->string('legal_color');
			$table->string('meta_title');
			$table->string('facebook_url')->nullable();
			$table->string('meta_description');
			$table->integer('company_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('campaign');
	}
}