<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Transaction extends Eloquent {

	protected $table = 'Transaction';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('order_id', 'product_id', 'user_id');

	public function transactionOrder()
	{
		return $this->hasOne('App\Models\Order', 'order_id');
	}

	public function transactionUser()
	{
		return $this->hasMany('App\Models\User', 'user_id');
	}

}