<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoryTable extends Migration {

	public function up()
	{
		Schema::create('Category', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 32);
			$table->string('slug', 32);
			$table->string('parent_id', 16)->default('0');
			$table->integer('attribute_id')->unsigned()->nullable();
			$table->string('status', 32);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('Category');
	}
}