<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name');
			$table->string('last_name');
			$table->string('email');
			$table->string('password');
			$table->string('gendre');
			$table->date('birth_date');
			$table->string('adresse');
			$table->string('diplome');
			$table->longText('tel');
			$table->string('cv');
			$table->integer('id_role')->unsigned();
			$table->integer('id_fiche')->unsigned();
			$table->integer('id_leave')->unsigned();
			$table->integer('contract_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}