<?php

namespace models;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'verified_code', 'password', 'role', 'phone', 'phone_verified');

    public function Products()
    {
        return $this->hasMany('models\Product', 'user_id');
    }

    public function FavouriteProducts()
    {
        return $this->belongsToMany('models\ProductUser');
    }

    public function ProductsInBasket()
    {
        return $this->belongsToMany('models\Basket');
    }

    public function address()
    {
        return $this->hasMany('models\Adress', 'user_id');
    }

    public function Orders()
    {
        return $this->hasMany('models\User');
    }

}