<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('product', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('product_user', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('basket', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('basket', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('adress', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('adress_id')->references('id')->on('adress')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('product_order', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('product_order', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('category_product', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('category_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('product', function(Blueprint $table) {
			$table->dropForeign('product_user_id_foreign');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->dropForeign('product_type_id_foreign');
		});
		Schema::table('product_user', function(Blueprint $table) {
			$table->dropForeign('product_user_product_id_foreign');
		});
		Schema::table('product_user', function(Blueprint $table) {
			$table->dropForeign('product_user_user_id_foreign');
		});
		Schema::table('basket', function(Blueprint $table) {
			$table->dropForeign('basket_user_id_foreign');
		});
		Schema::table('basket', function(Blueprint $table) {
			$table->dropForeign('basket_product_id_foreign');
		});
		Schema::table('adress', function(Blueprint $table) {
			$table->dropForeign('adress_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_adress_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('product_order', function(Blueprint $table) {
			$table->dropForeign('product_order_product_id_foreign');
		});
		Schema::table('product_order', function(Blueprint $table) {
			$table->dropForeign('product_order_order_id_foreign');
		});
		Schema::table('category_product', function(Blueprint $table) {
			$table->dropForeign('category_product_category_id_foreign');
		});
		Schema::table('category_product', function(Blueprint $table) {
			$table->dropForeign('category_product_product_id_foreign');
		});
	}
}