<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('news', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tags')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('intrests', function(Blueprint $table) {
			$table->foreign('sport_id')->references('id')->on('sports')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('player_events', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('player_events', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('set null')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('news', function(Blueprint $table) {
			$table->dropForeign('news_tag_id_foreign');
		});
		Schema::table('intrests', function(Blueprint $table) {
			$table->dropForeign('intrests_sport_id_foreign');
		});
		Schema::table('player_events', function(Blueprint $table) {
			$table->dropForeign('player_events_player_id_foreign');
		});
		Schema::table('player_events', function(Blueprint $table) {
			$table->dropForeign('player_events_event_id_foreign');
		});
	}
}