<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('subcategory', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shop', function(Blueprint $table) {
			$table->foreign('vendor_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('shop', function(Blueprint $table) {
			$table->foreign('min_qty_unit')->references('id')->on('measure_unit')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('shop', function(Blueprint $table) {
			$table->foreign('max_qty_unit')->references('id')->on('measure_unit')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('category')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->foreign('subcategory_id')->references('id')->on('subcategory')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->foreign('vendor_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_size_image', function(Blueprint $table) {
			$table->foreign('product_it')->references('id')->on('product')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('shop_banner', function(Blueprint $table) {
			$table->foreign('vendor_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('discount', function(Blueprint $table) {
			$table->foreign('vendor_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('subcategory', function(Blueprint $table) {
			$table->dropForeign('subcategory_category_id_foreign');
		});
		Schema::table('shop', function(Blueprint $table) {
			$table->dropForeign('shop_vendor_id_foreign');
		});
		Schema::table('shop', function(Blueprint $table) {
			$table->dropForeign('shop_min_qty_unit_foreign');
		});
		Schema::table('shop', function(Blueprint $table) {
			$table->dropForeign('shop_max_qty_unit_foreign');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->dropForeign('product_category_id_foreign');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->dropForeign('product_subcategory_id_foreign');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->dropForeign('product_vendor_id_foreign');
		});
		Schema::table('product_size_image', function(Blueprint $table) {
			$table->dropForeign('product_size_image_product_it_foreign');
		});
		Schema::table('shop_banner', function(Blueprint $table) {
			$table->dropForeign('shop_banner_vendor_id_foreign');
		});
		Schema::table('discount', function(Blueprint $table) {
			$table->dropForeign('discount_vendor_id_foreign');
		});
	}
}