<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('reservation_id')->unsigned();
			$table->integer('property_id')->unsigned();
			$table->decimal('price');
			$table->decimal('total_price');
			$table->decimal('tax');
			$table->decimal('cleanup_fees')->nullable()->default('0');
			$table->decimal('service_fees')->default('0');
			$table->decimal('hostable_fees')->nullable();
			$table->decimal('sale_code')->nullable()->default('0');
			$table->mediumInteger('points')->nullable()->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}