<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFilesTable extends Migration {

	public function up()
	{
		Schema::create('files', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 191)->nullable();
			$table->string('path', 191);
			$table->bigInteger('fileable_id')->unsigned();
			$table->string('fileable_type', 191);
			$table->boolean('is_active')->default(1);
			$table->tinyInteger('periority')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('files');
	}
}