<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequestsTable extends Migration {

	public function up()
	{
		Schema::create('requests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->json('name');
			$table->date('Expire_date')->nullable();
			$table->integer('company_id')->unsigned();
			$table->string('status')->nullable();
			$table->integer('reuqest_priority')->unsigned();
			$table->enum('show_type', array('user', 'group'))->nullable();
			$table->boolean('create_as_template')->nullable()->default(0);
			$table->json('notes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('requests');
	}
}