<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectTasksTable extends Migration {

	public function up()
	{
		Schema::create('project_tasks', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('short_title', 512)->nullable();
			$table->longText('description')->nullable();
			$table->float('progress')->nullable();
			$table->longText('pinned_note')->nullable();
			$table->integer('created_by_user_id')->nullable();
			$table->integer('task_to_user_id')->nullable();
			$table->integer('status_id')->nullable();
			$table->integer('parent_of')->nullable();
			$table->integer('child_of')->nullable();
			$table->integer('priority_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('project_tasks');
	}
}