<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->decimal('amount');
			$table->bigInteger('customer_id');
			$table->bigInteger('shipping_address_id');
			$table->bigInteger('billing_address_id');
			$table->bigInteger('payment_method_id')->unsigned();
			$table->tinyInteger('payment_status');
			$table->tinyInteger('status');
			$table->date('delivery_date');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}