<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerCouponsTable extends Migration {

	public function up()
	{
		Schema::create('customer_coupons', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('customer_id');
			$table->bigInteger('coupon_id');
			$table->date('from_date');
			$table->date('end_date');
			$table->tinyInteger('is_used');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('customer_coupons');
	}
}