<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContractMemberTable extends Migration {

	public function up()
	{
		Schema::create('contract_member', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('contract_id')->nullable();
			$table->integer('member_id')->nullable();
			$table->boolean('agree')->nullable()->default(0);
		});
	}

	public function down()
	{
		Schema::drop('contract_member');
	}
}