<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAttendanceTable extends Migration {

	public function up()
	{
		Schema::create('attendance', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('member_id')->nullable();
			$table->datetime('date')->nullable();
			$table->string('from_hour')->nullable();
			$table->string('to_hour')->nullable();
			$table->integer('total_hours')->nullable();
			$table->string('sign_in')->nullable();
			$table->string('sign_out')->nullable();
			$table->string('last_seen')->nullable();
			$table->string('month')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('attendance');
	}
}