<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTaskTable extends Migration {

	public function up()
	{
		Schema::create('task', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('project_id')->nullable();
			$table->integer('created_by')->nullable();
			$table->string('name');
			$table->text('description')->nullable();
			$table->datetime('start_at')->nullable();
			$table->datetime('end_at')->nullable();
			$table->string('status')->nullable();
			$table->string('priority')->nullable();
			$table->string('predicted_time')->nullable();
			$table->integer('rate')->nullable();
			$table->integer('progress')->nullable();
			$table->text('comment')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('task');
	}
}