<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectMemberTable extends Migration {

	public function up()
	{
		Schema::create('project_member', function(Blueprint $table) {
			$table->timestamps();
			$table->increments('id');
			$table->softDeletes();
			$table->integer('member_id')->nullable();
			$table->integer('project_id')->nullable();
			$table->integer('rate')->nullable();
			$table->text('comment')->nullable();
			$table->boolean('confirm')->nullable()->default(0);
		});
	}

	public function down()
	{
		Schema::drop('project_member');
	}
}