<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNoteTable extends Migration {

	public function up()
	{
		Schema::create('note', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('member_id')->nullable();
			$table->string('title')->nullable();
			$table->text('description')->nullable();
			$table->datetime('date')->nullable();
			$table->string('from_hour')->nullable();
			$table->string('to_hour')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('note');
	}
}