<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDepartmentTable extends Migration {

	public function up()
	{
		Schema::create('department', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->string('phone')->nullable();
			$table->integer('parent_id')->nullable();
			$table->text('description_en')->nullable();
			$table->text('description_ar')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('department');
	}
}