<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TaskReport extends Model 
{

    protected $table = 'task_report';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('task_id', 'member_id', 'status', 'title', 'report', 'respond', 'note');

    public function task()
    {
        return $this->belongsTo('Task', 'task_id');
    }

    public function member()
    {
        return $this->belongsTo('Member', 'member_id');
    }

}