<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TaskHistory extends Model 
{

    protected $table = 'task_history';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('task_id', 'created_by', 'description');

    public function task()
    {
        return $this->belongsTo('Task', 'task_id');
    }

    public function created_by()
    {
        return $this->belongsTo('Member', 'created_by');
    }

}