<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TaskFollower extends Model 
{

    protected $table = 'task_follower';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('member_id', 'task_id');

    public function member()
    {
        return $this->belongsTo('Member', 'member_id');
    }

    public function task()
    {
        return $this->belongsTo('Task', 'task_id');
    }

}