<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TaskCommentLike extends Model 
{

    protected $table = 'task_comment_like';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'created_by', 'comment_id');

    public function created_by()
    {
        return $this->belongsTo('Member', 'created_by');
    }

    public function comment()
    {
        return $this->belongsTo('TaskComment', 'comment_id');
    }

}