<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TaskComment extends Model 
{

    protected $table = 'task_comment';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('message', 'reply_on', 'created_by', 'task_id');

    public function task()
    {
        return $this->belongsTo('Task', 'task_id');
    }

    public function comment()
    {
        return $this->belongsTo('TaskComment', 'reply_on');
    }

    public function replies()
    {
        return $this->hasMany('TaskComment', 'reply_on');
    }

    public function member()
    {
        return $this->belongsTo('Member', 'created_by');
    }

    public function likes()
    {
        return $this->hasMany('TaskCommentLike', 'comment_id');
    }

}