<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TaskAssign extends Model 
{

    protected $table = 'task_assign';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('task_id', 'member_id');

    public function member()
    {
        return $this->belongsTo('Member', 'member_id');
    }

    public function task()
    {
        return $this->belongsTo('Task', 'task_id');
    }

}