<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Task extends Model 
{

    protected $table = 'task';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('project_id', 'created_by', 'name', 'description', 'start_at', 'end_at', 'status', 'priority', 'predicted_time', 'rate', 'progress', 'comment');

    public function created_by()
    {
        return $this->belongsTo('Member', 'created_by');
    }

    public function project()
    {
        return $this->belongsTo('Project', 'project_id');
    }

    public function lists()
    {
        return $this->hasMany('CheckList', 'task_id');
    }

    public function assigns()
    {
        return $this->belongsToMany('Member', 'task_assign', 'task_id', 'member_id');
    }

    public function followers()
    {
        return $this->belongsToMany('Member', 'task_follower', 'task_id', 'member_id');
    }

    public function histories()
    {
        return $this->hasMany('TaskHistory', 'task_id');
    }

    public function comments()
    {
        return $this->hasMany('TaskComment', 'task_id');
    }

    public function reports()
    {
        return $this->hasMany('TaskReport', 'task_id');
    }

}