<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Supervisor extends Model 
{

    protected $table = 'supervisor';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('supervisor_id', 'department_id');

    public function supervisor()
    {
        return $this->belongsTo('Member', 'supervisor_id');
    }

    public function department()
    {
        return $this->belongsTo('Department', 'department_id');
    }

}