<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProjectReport extends Model 
{

    protected $table = 'project_report';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('project_id', 'created_by', 'to_member_id', 'status', 'title', 'report', 'respond', 'note');

    public function project()
    {
        return $this->belongsTo('Project', 'project_id');
    }

    public function to_member()
    {
        return $this->belongsTo('Member', 'to_member_id');
    }

    public function creator()
    {
        return $this->belongsTo('Member', 'created_by');
    }

}