<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProjectMember extends Model 
{

    protected $table = 'project_member';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('member_id', 'project_id', 'rate', 'comment', 'confirm');

    public function member()
    {
        return $this->belongsTo('Member', 'member_id');
    }

    public function project()
    {
        return $this->belongsTo('Project', 'project_id');
    }

}