<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProjectHistory extends Model 
{

    protected $table = 'project_history';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('project_id', 'created_by', 'description');

    public function project()
    {
        return $this->belongsTo('Project', 'project_id');
    }

    public function created_by()
    {
        return $this->belongsTo('Member', 'created_by');
    }

}