<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PostSchedule extends Model 
{

    protected $table = 'post_schedule';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('post_id', 'date', 'publish');

    public function post()
    {
        return $this->belongsTo('Post', 'post_id');
    }

}