<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PostConfirm extends Model 
{

    protected $table = 'post_confirm';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('post_id', 'member_id');

    public function post()
    {
        return $this->belongsTo('Post', 'post_id');
    }

    public function member()
    {
        return $this->belongsTo('Member', 'member_id');
    }

}