<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PostCity extends Model 
{

    protected $table = 'post_city';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('city_id', 'post_id');

    public function post()
    {
        return $this->belongsTo('Post', 'post_id');
    }

    public function city()
    {
        return $this->belongsTo('City', 'city_id');
    }

}