<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Note extends Model 
{

    protected $table = 'note';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('member_id', 'title', 'description', 'date', 'from_hour', 'to_hour');

    public function member()
    {
        return $this->belongsTo('Member', 'member_id');
    }

}