<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MemberDepartment extends Model 
{

    protected $table = 'member_department';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('member_id', 'department_id');

    public function member()
    {
        return $this->belongsTo('Member', 'member_id');
    }

    public function department()
    {
        return $this->belongsTo('Department', 'department_id');
    }

}