<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GroupTag extends Model 
{

    protected $table = 'group_tag';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('tag_id', 'group_id');

    public function group()
    {
        return $this->belongsTo('Group', 'group_id');
    }

    public function tag()
    {
        return $this->belongsTo('Tag', 'tag_id');
    }

}