<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GroupRate extends Model 
{

    protected $table = 'group_rate';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('group_id', 'member_id', 'rate', 'review');

    public function member()
    {
        return $this->belongsTo('Member', 'member_id');
    }

    public function group()
    {
        return $this->belongsTo('Group', 'group_id');
    }

}