<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GroupPost extends Model 
{

    protected $table = 'group_post';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('post_id', 'group_id');

    public function post()
    {
        return $this->belongsTo('Post', 'post_id');
    }

    public function group()
    {
        return $this->belongsTo('Group', 'group_id');
    }

}