<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GroupMember extends Model 
{

    protected $table = 'group_member';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('member_id', 'group_id');

    public function member()
    {
        return $this->belongsTo('Member', 'member_id');
    }

    public function group()
    {
        return $this->belongsTo('Group', 'group_id');
    }

}