<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GroupInvitation extends Model 
{

    protected $table = 'group_invitation';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('group_id', 'member_id', 'sender_id', 'status', 'approve');

    public function member()
    {
        return $this->belongsTo('Member', 'member_id');
    }

    public function sender()
    {
        return $this->belongsTo('Member', 'sender_id');
    }

    public function group()
    {
        return $this->belongsTo('Group', 'group_id');
    }

}