<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GroupAdmin extends Model 
{

    protected $table = 'group_admin';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('group_admin_id', 'group_id');

    public function group_admin()
    {
        return $this->belongsTo('Member', 'group_admin_id');
    }

    public function group()
    {
        return $this->belongsTo('Group', 'group_id');
    }

}