<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FileHistory extends Model 
{

    protected $table = 'file_history';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('created_by', 'description', 'drive_id');

    public function created_by()
    {
        return $this->belongsTo('Member', 'created_by');
    }

    public function drive()
    {
        return $this->belongsTo('Drive', 'drive_id');
    }

}