<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Contract extends Model 
{

    protected $table = 'contract';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('created_by', 'title', 'description');

    public function created_by()
    {
        return $this->belongsTo('Member', 'created_by');
    }

    public function members()
    {
        return $this->belongsToMany('Member', 'contract_member', 'contract_id', 'member_id');
    }

}