<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CommentReaction extends Model 
{

    protected $table = 'comment_reaction';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('comment_id', 'reaction_id', 'created_by');

    public function comment()
    {
        return $this->belongsTo('PostComment', 'comment_id');
    }

    public function reaction()
    {
        return $this->belongsTo('Reaction', 'reaction_id');
    }

    public function created_by()
    {
        return $this->belongsTo('Member', 'created_by');
    }

}