<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CommentMention extends Model 
{

    protected $table = 'comment_mention';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('comment_id', 'created_by', 'member_id');

    public function member()
    {
        return $this->belongsTo('Member', 'member_id');
    }

    public function created_by()
    {
        return $this->belongsTo('Member', 'created_by');
    }

    public function comment()
    {
        return $this->belongsTo('PostComment', 'comment_id');
    }

}